<?php
/**
* tap Payment Gateway Module
*
* tap Payment Gateway module allow you to accept online payments utilizing tap
* Payment Gateway and from within WHMCS
* Code By Ismail mohammed Diddig - DataSource
* distribution by zoolhost.com - https://www.zoolhost.com/client/cart.php?a=add&pid=61
* @copyright Copyright (c) tap 2021
*/

if (!defined("WHMCS")) {
	die("This file cannot be accessed directly");
}


/**
* Define module related meta data.
*
* Values returned here are used to determine module related capabilities and
* settings.
*
* @see http://docs.whmcs.com/Gateway_Module_Meta_Data_Parameters
*
* @return array
*/
function tappg_MetaData()
{
	return array(
	'DisplayName' => 'Tap Payment Gateway',
	'APIVersion' => '1.5', // Use API Version 2.0
	'DisableLocalCredtCardInput' => true,
	'TokenisedStorage' => false,
	);
}

/**
* Define gateway configuration options.
*
* Thsee are the configuration options that are presented to administrator users
* when activating and configuring tap payment gateway module for use.
*
* @return array
*/
function tappg_config()
{
	return array(
	'FriendlyName' => array(
	'Type' => 'System',
	'Value' => 'Tap Payment Gateway',
	),
	// tap Test URL
	'tapTestURL' => array(
	'FriendlyName' => 'tap Test URL',
	'Type' => 'text',
	'Size' => '40',
	'Default' => 'https://api.tap.company/v2/charges',
	'Description' => 'The URL for tap Test Enviroment',
	),
	// tap Production URL
	'tapProductionURL' => array(
	'FriendlyName' => 'tap Production URL',
	'Type' => 'text',
	'Size' => '40',
	'Default' => 'https://api.tap.company/v2/charges',
	'Description' => 'The URL for tap Production Enviroment',
	),
	// secretkey
	'secretkey' => array(
	'FriendlyName' => 'Secret Key',
	'Type' => 'text',
	'Size' => '80',
	'Default' => 'sk_test_XKokBfNWv6FIYuTMg5sLPjhJ',
	'Description' => 'The  tap secretkey start with sk',
	),
	// whmcs path
	'whmcsPath' => array(
	'FriendlyName' => 'WHMCS path',
	'Type' => 'text',
	'Size' => '80',
	'Default' => 'https://domain.com/whmcs-folder',
	'Description' => 'The  whmcs full path',
	),
	// Working with Test Env or Production
	'tapTestMode' => array(
	'FriendlyName' => 'Still Testing?',
	'Type' => 'yesno',
	'Description' => 'Tick for tap Test Enviroment',
	),
	);
}

/**
* Payment link.
*
* Required by third party payment gateway modules only.
*
* Defines the HTML output displayed on an invoice. Typically consists of an
* HTML form that will take the user to the payment gateway endpoint.
*
* @param array $params Payment Gateway Module Parameters
*
* @see http://docs.whmcs.com/Payment_Gateway_Module_Parameters
*
* @return string
*/
function tappg_link($params)
{
	$gatewayModuleName = basename(__FILE__, '.php');

	$secret = $params['secretkey'];

	$testMode = $params['tapTestMode'];

	if ($testMode) {
		$url = $params['tapTestURL'];
	} else {
		$url = $params['tapProductionURL'];
	}

	$whmcs_url = $params['whmcsPath'];

	$tap_url =  $url;

	$function_url = $whmcs_url."/modules/gateways/tappg/TapPayment.php";
	$redirecturl = $whmcs_url."/modules/gateways/callback/tappg.php";

	// defulte
	$firstname ="No name";
	$lastname ="No name";
	$phone = "0123456789";

	$invoiceId = $params['invoiceid'];
	$amount = $params['amount'];
	$description = $params['description'];
	$currency = $params['currency'];

	$firstname = $params['clientdetails']['firstname'];
	$lastname = $params['clientdetails']['lastname'];
	$langPayNow = $params['langpaynow'];
	$email = $params['clientdetails']['email'];
	$phone = $params['clientdetails']['phonenumber'];

	$country_code = $params['clientdetails']['phonecc'];
	$country = $params['clientdetails']['country'];


	//$redirecturl2 = $params['returnurl'];
	// $customerRef  = $invoiceId;
	$customerName = $firstname." ".$lastname;
	$remarks = $invoiceId;


	$title = $params['invoiceid'];
	$details = $params['invoiceid'];
	$vat = "0";
	$total = $params['amount'];
	$save_card = "TRUE";
	$udf1 = "null";
	$udf2 = "null";

	$product = array ("title"=> $invoiceId,"details"=> $description,"amount"=> $amount,"vat"=> $vat, "total"=> $total);


	return '<form method="post" action="'.$function_url.'">
	<input type="hidden"  name="first_name" value="' . $firstname . '" />
	<input type="hidden"  name="last_name" value="' . $lastname . '" />
	<input type="hidden"  name="name" value="' . $customerName . '" />
	<input type="hidden"  name="amount" value="' . $amount. '" />
	<input type="hidden"  name="currency" value="' . $currency . '" />
	<input type="hidden"  name="phone" value="' . $phone . '" />
	<input type="hidden"  name="email" value="' . $email . '" />
	<input type="hidden"  name="return_url" value="' . $redirecturl . '" />
	<input type="hidden"  name="post_url" value="' . $function_url . '" />
	<input type="hidden"  name="order" value="' . $invoiceId . '" />
	<input type="hidden"  name="description" value="' . $description . '" />
	<input type="hidden"  name="url" value="' . $tap_url . '" />
	<input type="hidden"  name="title" value="' . $title . '" />
	<input type="hidden"  name="details" value="' . $details . '" />
	<input type="hidden"  name="vat" value="' . $vat . '" />
	<input type="hidden"  name="total" value="' . $total . '" />
	<input type="hidden"  name="secret" value="' . $secret . '" />
	<input type="hidden"  name="save_card" value="' . $save_card . '" />
	<input type="hidden"  name="udf1" value="' . $udf1 . '" />
	<input type="hidden"  name="udf2" value="' . $udf2 . '" />
	<input type="hidden"  name="country_code" value="' . $country_code . '" />
	<input type="submit" value="' . $langPayNow . '" />
	<input type="image" value="' . $langPayNow . '" src="tappg/tap.png" alt="" />
        </form>';
}

