<?php

/**
* tap Payment Gateway Module
*
* tap Payment Gateway module allow you to accept online payments utilizing tap
* Payment Gateway and from within WHMCS
* Code By Ismail mohammed Diddig - DataSource
* distribution by zoolhost.com - https://www.zoolhost.com/client/cart.php?a=add&pid=61
* @copyright Copyright (c) tap 2021
*/

ob_start(); // needs to be added here
// Require libraries needed for gateway module functions.
require_once __DIR__ . '/../../../init.php';
require_once __DIR__ . '/../../../includes/gatewayfunctions.php';
require_once __DIR__ . '/../../../includes/invoicefunctions.php';

function tappg_LogActivity($message, $adminuser="ismail")
{
	$values["description"] = $message;
	return localAPI("logactivity",$values,$adminuser);
}



// Detect module name from filename.
$gatewayModuleName = basename(__FILE__, '.php');

// Fetch gateway configuration parameters.
$gatewayParams = getGatewayVariables($gatewayModuleName);

// Die if module is not active.
if (!$gatewayParams['type']) {
	die("Module Not Activated");
}

$secret = $gatewayParams['secretkey'];
$testMode = $gatewayParams['tapTestMode'];
$whmcsUrl =  $gatewayParams['whmcsPath'];



$tap_chargeid = $_GET['tap_id'];
$tap_ref = $_GET['tap_id'];

$tap_url = "https://api.tap.company/v2/charges/".$tap_chargeid;


echo $tap_url;
$success = false;
$json_result = tappg_retrive($tap_url,$secret);
$data_decoded = json_decode($json_result, true);



$tap_response_id = $data_decoded['id'];
$tap_response_status = $data_decoded['status'];
$tap_response_amount = $data_decoded['amount'];
$tap_response_currency = $data_decoded['currency'];

$tap_response_authorization_id = $data_decoded['transaction']['authorization_id'];
$tap_response_created = $data_decoded['transaction']['created'];

$tap_response_track = $data_decoded['reference']['track'];
$tap_response_payment = $data_decoded['reference']['payment'];
$tap_response_order = $data_decoded['reference']['order'];


$tap_response_code = $data_decoded['response']['code'];
$tap_response_message = $data_decoded['response']['message'];


$tap_response_red_status = $data_decoded['redirect']['status'];
$tap_response_red_url = $data_decoded['redirect']['url'];


$invoiceId = $tap_response_order;
$paymentAmount = $tap_response_amount;


$redirecturl = $whmcsUrl."/viewinvoice.php?id=".$invoiceId;


# Fetch invoice to get the amount and userid
$result = mysql_fetch_assoc(select_query('tblinvoices', 'total, userid', array("id"=>$invoiceId)));
$amount = $result['total'];
# Check if amount is USD, convert if not.
//$currency = getCurrency();
$result = mysql_fetch_assoc(select_query('tblclients', 'currency', array("id"=>$result['userid'])));
$currency_id = $result['currency'];
$result = mysql_fetch_array(select_query("tblcurrencies", "id", array("code"=>'USD')));
$aed_id = $result['id'];
if ($currency_id != $aed_id) {
	$converted_amount = convertCurrency($paymentAmount, $aed_id, $currency_id);
} else {
	$converted_amount = $paymentAmount;
}



if ( $tap_response_status == "CAPTURED") {
	$transactionStatus = 'Payment Success';
	$success = true;


	$invoiceId = checkCbInvoiceID($invoiceId, $gatewayParams['name']);


	$paymentFee = 0;
	$transactionId = $tap_response_id;
	logTransaction($gatewayParams['name'], $json_result, $transactionStatus);

	checkCbTransID($transactionId);
	addInvoicePayment($invoiceId, $transactionId, $converted_amount, $paymentFee, $gatewayModuleName);

	##### Start Admin API Call #####
	$command = "updateinvoice";
	$values["invoiceid"] = $invoiceId;

	$values["status"] = "Paid";

	$results = localAPI($command,$values,"admin");
	##### End Admin API Call #####

	header("Location: $redirecturl");

} else {
	$transactionStatus =  "Payment Failure";
	logTransaction($gatewayParams['name'], $json_result, $transactionStatus);

	header("Location: $redirecturl");
}


function tappg_retrive($url, $secret_tx)
{
	$curl = curl_init();

	curl_setopt_array($curl, array(
	CURLOPT_URL =>  $url,
	CURLOPT_RETURNTRANSFER => true,
	CURLOPT_ENCODING => "",
	CURLOPT_MAXREDIRS => 10,
	CURLOPT_TIMEOUT => 30,
	CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
	CURLOPT_CUSTOMREQUEST => "GET",
	CURLOPT_POSTFIELDS => "{}",
	CURLOPT_HTTPHEADER => array(
	"authorization: Bearer ".$secret_tx,
	"content-type: application/json"
	),
	));

	$response = curl_exec($curl);
	$err = curl_error($curl);

	curl_close($curl);

	if ($err) {
		echo "cURL Error #:" . $err;
	} else {
		return $response;
	}
}




